# cyac

基于 Ollama 的 Rust 命令行 AI 编程助手。完全本地化、隐私安全、高性能。

## 功能特性

- **代码解释**：解释指定代码段的逻辑
- **智能重构**：重命名符号、提取函数
- **代码生成**：根据描述生成函数实现
- **测试生成**：基于现有代码生成单元测试
- **代码分析**：复杂度分析、依赖分析
- **文档生成**：生成 API 文档
- **交互对话**：chat 与 REPL 模式
- **项目会话**：保持上下文的会话模式
- **批量确认写入**：会话中 `save <path>` 将 AI 回复保存到文件，首次确认后同目录免确认

## 环境要求

- Rust 1.75+
- Ollama 0.5+（需单独安装并启动）
- 推荐模型：deepseek-coder:6.7b、qwen2.5-coder:7b

## 安装

```bash
# 从源码编译
cargo install --path .

# 或克隆后
cd cyac && cargo build --release
```

## 首次使用

1. 确保 Ollama 已安装并运行：
   ```bash
   ollama serve
   ollama pull deepseek-coder
   ```

2. 运行 cyac 查看欢迎信息与可用模型：
   ```bash
   cyac
   ```

3. 设置默认模型（可选）：
   ```bash
   cyac config set model deepseek-coder
   ```

## 使用案例

更多常用开发场景与示例，请参阅 [docs/EXAMPLES.md](docs/EXAMPLES.md)。

## 命令速查

```bash
# 代码理解
cyac explain src/main.rs
cyac explain src/main.rs:25-40
cyac explain --stdin < main.rs

# 代码操作
cyac refactor rename --old old_name --new new_name --path src/lib.rs
cyac refactor extract --lines 25-40 --name helper --path src/main.rs
cyac generate function --name calculate --desc "计算两数之和" --lang rust

# 测试与文档
cyac test generate --path src/lib.rs
cyac doc generate --path src/lib.rs --format markdown

# 交互模式
cyac chat "如何优化这个算法？"
cyac repl
cyac session start --project ./
# 会话中: save src/xxx.rs 将上次 AI 回复保存（首次会确认，确认后同目录免确认）
```

## 配置

配置文件位于 `~/.config/cyac/config.yaml`：

```yaml
version: 1
model:
  default: "deepseek-coder:6.7b"
  fallback: "qwen2.5-coder:7b"
context:
  max_tokens: 16000
  include_git_history: true
  ignore_patterns:
    - "**/node_modules"
    - "**/target"
    - "**/.git"
features:
  auto_save_backup: true
  confirm_before_write: true   # 写入前批量确认：首次 save 确认后，本次会话内同目录免确认
  enable_telemetry: false
```

**主要配置项**：
| 配置项 | 说明 |
|--------|------|
| `model.default` | 默认模型 |
| `features.confirm_before_write` | 会话中 save 时是否首次确认（true 时首次确认后同目录免确认） |
| `context.ignore_patterns` | 上下文收集时忽略的目录 |

## 项目配置

在项目目录运行 `cyac init` 可创建 `.cyac/config.yaml` 项目级配置。

## 打包分发

将 cyac 打包给其他用户使用，请参阅 [docs/DISTRIBUTION.md](docs/DISTRIBUTION.md)。

**Windows** 快速打包：
```powershell
.\scripts\windows\build-release.ps1
```
生成 `dist/cyac-v0.1.0-windows-x64.zip`。用户解压后**双击 install.bat** 即可安装。

**Linux / macOS** 打包：
```bash
./scripts/linux/build-release.sh
```
生成 `dist/cyac-v0.1.0-{os}-{arch}.tar.gz`。用户解压后执行 `./install.sh` 即可安装。

## 开发

```bash
cargo build
cargo test
cargo run -- --help
cargo clippy
```

## 许可证

MIT
