# cyac Install Script (Windows)
# Installs cyac to user dir and adds to PATH

$ErrorActionPreference = "Stop"
$scriptDir = if ($PSScriptRoot) { $PSScriptRoot } else { Split-Path -Parent $MyInvocation.MyCommand.Path }
$installDir = "$env:LOCALAPPDATA\Programs\cyac"

Write-Host "cyac Installer" -ForegroundColor Cyan
Write-Host "================" -ForegroundColor Cyan
Write-Host ""

$exePath = Join-Path $scriptDir "cyac.exe"
if (-not (Test-Path $exePath)) {
    Write-Host "Error: cyac.exe not found. Please run from extracted folder." -ForegroundColor Red
    Read-Host "Press Enter to exit"
    exit 1
}

New-Item -ItemType Directory -Force -Path $installDir | Out-Null

Write-Host "Installing to: $installDir" -ForegroundColor Yellow
Copy-Item $exePath $installDir -Force
if (Test-Path (Join-Path $scriptDir "README.md")) {
    Copy-Item (Join-Path $scriptDir "README.md") $installDir -Force
}

$userPath = [Environment]::GetEnvironmentVariable("Path", "User")
if ($userPath -notlike "*$installDir*") {
    [Environment]::SetEnvironmentVariable("Path", "$userPath;$installDir", "User")
    Write-Host "Added to user PATH" -ForegroundColor Green
} else {
    Write-Host "PATH already contains install dir" -ForegroundColor Gray
}

Write-Host ""
Write-Host "Install complete!" -ForegroundColor Green
Write-Host ""
Write-Host "Please close and reopen terminal, then run: cyac --help" -ForegroundColor Yellow
Write-Host ""
Write-Host "Before use, install Ollama and pull model:" -ForegroundColor Cyan
Write-Host "  1. Install Ollama: https://ollama.ai" -ForegroundColor Gray
Write-Host "  2. Pull model: ollama pull deepseek-coder" -ForegroundColor Gray
Write-Host ""
